/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.texture;

import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;

public abstract class CustomTextureData {
    private CustomTextureData() {
    }

    public static class RawDataRect
    extends RawData2D {
        public RawDataRect(byte[] byArray, TextureFilteringData textureFilteringData, InternalTextureFormat internalTextureFormat, PixelFormat pixelFormat, PixelType pixelType, int n, int n2) {
            super(byArray, textureFilteringData, internalTextureFormat, pixelFormat, pixelType, n, n2);
        }
    }

    public static final class RawData3D
    extends RawData {
        int sizeX;
        int sizeY;
        int sizeZ;

        public RawData3D(byte[] byArray, TextureFilteringData textureFilteringData, InternalTextureFormat internalTextureFormat, PixelFormat pixelFormat, PixelType pixelType, int n, int n2, int n3) {
            super(byArray, textureFilteringData, internalTextureFormat, pixelFormat, pixelType);
            this.sizeX = n;
            this.sizeY = n2;
            this.sizeZ = n3;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public int getSizeZ() {
            return this.sizeZ;
        }
    }

    public static class RawData2D
    extends RawData {
        int sizeX;
        int sizeY;

        public RawData2D(byte[] byArray, TextureFilteringData textureFilteringData, InternalTextureFormat internalTextureFormat, PixelFormat pixelFormat, PixelType pixelType, int n, int n2) {
            super(byArray, textureFilteringData, internalTextureFormat, pixelFormat, pixelType);
            this.sizeX = n;
            this.sizeY = n2;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }
    }

    public static final class RawData1D
    extends RawData {
        private final int sizeX;

        public RawData1D(byte[] byArray, TextureFilteringData textureFilteringData, InternalTextureFormat internalTextureFormat, PixelFormat pixelFormat, PixelType pixelType, int n) {
            super(byArray, textureFilteringData, internalTextureFormat, pixelFormat, pixelType);
            this.sizeX = n;
        }

        public int getSizeX() {
            return this.sizeX;
        }
    }

    public static abstract class RawData
    extends CustomTextureData {
        private final byte[] content;
        private final InternalTextureFormat internalFormat;
        private final PixelFormat pixelFormat;
        private final PixelType pixelType;
        private final TextureFilteringData filteringData;

        private RawData(byte[] byArray, TextureFilteringData textureFilteringData, InternalTextureFormat internalTextureFormat, PixelFormat pixelFormat, PixelType pixelType) {
            this.content = byArray;
            this.filteringData = textureFilteringData;
            this.internalFormat = internalTextureFormat;
            this.pixelFormat = pixelFormat;
            this.pixelType = pixelType;
        }

        public final byte[] getContent() {
            return this.content;
        }

        public TextureFilteringData getFilteringData() {
            return this.filteringData;
        }

        public final InternalTextureFormat getInternalFormat() {
            return this.internalFormat;
        }

        public final PixelFormat getPixelFormat() {
            return this.pixelFormat;
        }

        public final PixelType getPixelType() {
            return this.pixelType;
        }
    }

    public static final class ResourceData
    extends CustomTextureData {
        private final String namespace;
        private final String location;

        public ResourceData(String string, String string2) {
            this.namespace = string;
            this.location = string2;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getLocation() {
            return this.location;
        }
    }

    public static final class LightmapMarker
    extends CustomTextureData {
        public boolean equals(Object object) {
            return object.getClass() == this.getClass();
        }

        public int hashCode() {
            return 33;
        }
    }

    public static final class PngData
    extends CustomTextureData {
        private final TextureFilteringData filteringData;
        private final byte[] content;

        public PngData(TextureFilteringData textureFilteringData, byte[] byArray) {
            this.filteringData = textureFilteringData;
            this.content = byArray;
        }

        public TextureFilteringData getFilteringData() {
            return this.filteringData;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

